### Jericho Comms - Information-theoretically secure communications
#### Copyright (c) 2013-2026  Joshua M. David


This directory contains a configuration file `config.json` to configure the server API. It is a JSON file so the
data can easily be edited, saved and read from other scripts. Usually you won't need to manually edit this and the
setup.sh script can perform most operations. However the values are documented below if you need to edit it:

{
	// Database config - Credentials for PHP to access the PostgreSQL server database
    "databaseConfig": {

		// The hostname (generally PostgreSQL is on the same machine so you probably do not need to edit this)
        "databaseHostname": "127.0.0.1",

		// Database password (replaced by server installation script)
        "databasePassword": "jerichopassword",

		// Database username (generally the default of jerichouser will be fine so you likely do not need to edit this)
        "databaseUsername": "jerichouser",

		// The port (generally 5432 is the default PostgreSQL port so you likely do not need to edit this)
        "databasePort": 5432
    },

	// Application config - Some settings specific to testing
    "applicationConfig": {

		// Enables messages in the HTTP 200 header responses for debug purposes. Should be false for a live server as
		// it leaks meta data in the response code if there is an error. If the client is having trouble connecting, try
		// setting the value to `true`. This will enable debug messages to be sent back with the responses which are
		// viewable in the browser's development tools.
        "testResponseHeaders": false
    },

	// Chat group configuration - Each array entry will be a separate object representing the chat group's configuration
    "groupConfigs": [
        {
			// The 64 bit Group ID in lowercase hexadecimal symbols e.g. 'c7ba48d...' (16 hex characters in length).
            "groupId": "jerichogroupid",

			// Name of the database for the chat group, which is `jerichodb_` and the group ID concatenated together.
			// This is automatic in the setup script because the SQL installation script must be changed as well.
			"groupDatabaseName": "jerichodbgroupid",

			// The 512 bit server key in lowercase hexadecimal symbols e.g. 'c7ba48d...' (128 hex characters in length).
			// This is automatically replaced by the server installation script. This used to sign all data going to or
			// from the server using the Skein-512 hash. This key is ideally generated by the TRNG in the client
			// application and exported for each user with their one-time pads so they can connect to the server to
			// send/receive messages.
            "groupServerKey": "jerichoserverkey",

			// Valid number of users for this chat group (currently only 2, 3, 4, 5, 6 or 7 (integers) are supported)
            "groupNumberOfUsers": 2
        }
    ]
}
